<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="./assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <meta name="robots" content="noindex, nofollow">
    <meta name="theme-color" content="#1B2B45">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css" integrity="sha512-yHknP1/AwR+yx26cB1y0cjvQUMvEa2PFzt1c9LlS4pRQ5NOTZFWbhBig+X9G9eYW/8m0/4OXNx8pxJ6z57x0dw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick-theme.min.css" integrity="sha512-17EgCFERpgZKcm0j0fEq1YCJuyAWdz9KUtv1EjVuaOz8pDnh/0nZxmU6BBXwaaxqoi9PQXnRWqlcDB027hgv9A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
</head>
<body>
        <header id="myform">    
                <nav>
                            <div class="logo"><img src="./assets/images/logo/newlogo2.png" alt="" width="230px"></div>
                            <div class="menue">
                                        <ul>
                                                <li><a href="mailto:support.geims@geu.ac.in"><span>support.geims@geu.ac.in</span></a></li>
                                                <li><a href="tel:18008897351"><img src="./assets/images/img/call.png" alt=""><span>18008897351</span></a></li>
                                        </ul>
                            </div>
                </nav>
        </header>

                    <main >
                        <!-- banner part -->
                                <section class="banner-part" >
                                            <div class="container2">
                                                    <div class="row">
                                                            <div class="col-sm-12 col-lg-6">
                                                                        <div class="banner-content">
                                                                                <h1 data-aos="fade-down"  data-aos-duration="400">Graphic Era Hospital: Your Partner in Obstetrics and Gynaecological Care </h1>
                                                                                <!-- <p>Prioritise health at every stage of life. Consult leading obstetricians and gynaecologists in Dehradun at Graphic Era Hospital for reproductive and maternity care.</p> -->
                                                                                <ul>
                                                                                    <li data-aos="fade-up" data-aos-duration="600"><img src="./assets/images/img/check.png" alt="Graphic Era Hospital"><span>Experienced Obstetricians & Gynaecologists
                                                                                    </span></li>
                                                                                    <li data-aos="fade-up" data-aos-duration="800"><img src="./assets/images/img/check.png" alt="Graphic Era Hospital"><span>Minimally Invasive Gynaecologic Surgery
                                                                                    </span></li>
                                                                                    <li data-aos="fade-up" data-aos-duration="900"><img src="./assets/images/img/check.png" alt="Graphic Era Hospital"><span>Comprehensive Maternal and Gynaecological Care</span></li>
                                                                                    <li data-aos="fade-up" data-aos-duration="900"><img src="./assets/images/img/check.png" alt="Graphic Era Hospital"><span>High-Risk Pregnancy Management
                                                                                    </span></li>
                                                                                </ul>
                                                                                <a href="tel:18008897351" class="banner-btn" data-aos="fade-up" data-aos-duration="1000"><span>Book an Appointment</span></a>
                                                                        </div>
                                                            </div>
                                                            <div class="col-sm-12 col-lg-6" data-aos="fade-left" data-aos-duration="600" data-aos-easing="ease-in-sine" >
                                                                    <div class="my-formpart">
                                                                            <h2>GET A CALL BACK FROM OUR HEALTH ADVISOR</h2>
                                                                            <div class="form-row" >
                                                                                <form method="post" action="processmail.php">                                                                                                                                                                                                                                                                                                                                                                                                                    
                                                                                    <div class="input1">
                                                                                           <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512l388.6 0c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304l-91.4 0z"/></svg>
                                                                                            <input type="text" name="name" placeholder="Enter Your Name **" required>
                                                                                            <input type="hidden" id="utm_source" name="utm_source">
                                                    <?php 		$requestUrl = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>
                <input type="hidden" id="utm_medium" name="utm_medium">
                <input type="hidden" id="utm_campaign" name="utm_campaign">
                
                <input type="hidden" id="source_url" name="source_url" value="<?php echo $requestUrl ?>">
                                                                                    </div>
                                                                                
                                                                                 <div class="input1">
                                                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M48 64C21.5 64 0 85.5 0 112c0 15.1 7.1 29.3 19.2 38.4L236.8 313.6c11.4 8.5 27 8.5 38.4 0L492.8 150.4c12.1-9.1 19.2-23.3 19.2-38.4c0-26.5-21.5-48-48-48L48 64zM0 176L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-208L294.4 339.2c-22.8 17.1-54 17.1-76.8 0L0 176z"/></svg>
                                                                                     <input type="email" name="email" placeholder="Enter Your Email **" required>
                                                                             </div>
                                                                             <div class="input1">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M164.9 24.6c-7.7-18.6-28-28.5-47.4-23.2l-88 24C12.1 30.2 0 46 0 64C0 311.4 200.6 512 448 512c18 0 33.8-12.1 38.6-29.5l24-88c5.3-19.4-4.6-39.7-23.2-47.4l-96-40c-16.3-6.8-35.2-2.1-46.3 11.6L304.7 368C234.3 334.7 177.3 277.7 144 207.3L193.3 167c13.7-11.2 18.4-30 11.6-46.3l-40-96z"/></svg>
                                                                                 <input type="tel" name="phone" placeholder="Enter Your Number **" required pattern="[0-9]{10}" title="Please enter valid 10 digits phone number">
                                                                         </div>
                                                                             <div class="input1 texrarea">
                                                                                
                                                                               <input type="text" name="message" placeholder="Write Your Query (Optional)">
                                                                         </div>
                                                                         <div class="input1">
                                                                                <button type="submit" class="submitbtn">Get Started</button>
                                                                         </div>
                                                                            </form>
                                                                               </div>
                                                                    </div>
                                                            </div>
                                                    </div>
                                            </div>
                                </section>
                                <!-- banner part end -->
                                 <section class="about-part py-5">
                                        <div class="container2">
                                                <div class="row">
                                                           <div class="col-12">
                                                                    <h2 class="text-center mb-5 heading1" data-aos="fade-down"  data-aos-duration="400">Why Choose Graphic Era Hospital?</h2>
                                                            </div>
                                                            <div class="col-sm-12" >
                                                                    <p data-aos="fade-up" data-aos-duration="600">Graphic Era Hospital is a trusted name for obstetrics and gynaecology care in Dehradun. Offering an integrated approach, the hospital combines advanced diagnostics, modern treatments, and compassionate care. With a focus on women’s health, the hospital provides treatment for a variety of obstetric and gynaecological concerns.
                                                                    </p>
                                                                   <h5 data-aos="fade-up" data-aos-duration="800"> From routine check-ups to complex procedures, our services include:</h5>
                                                            </div>
                                                </div>
                                                <div class="row mt-5">
                                                        <div class="col-sm-12 col-lg-6"  data-aos="fade-right" data-aos-duration="400" data-aos-easing="ease-in-sine">
                                                            <div class="faq-group topfaq">
                     
                                                                <div class="faq-right">
                                                                    <div class="faq-main">
                                                                        <div class="faq-item  ">
                                                                            <div class="faq-label activebg1"><p>1.Maternity Services</p><img src="./assets/images/img/agine.png" alt=""></div>
                                                                            <!-- <div class="faq-cont">
                                                                                <p><b>FMCG market research</b> helps businesses understand consumer behavior, identify market trends, and assess competitor activities. This allows companies to make informed decisions, enhance product offerings, and improve brand positioning in a highly competitive industry.</p>
                                                                            </div> -->
                                                                        </div>
                                                                        <div class="faq-item">
                                                                            <div class="faq-label"><p>2. Gynaecological Treatments</p><img src="./assets/images/img/heartpp-removebg-preview (1).png" alt=""></div>
                                                                            <!-- <div class="faq-cont">
                                                                                <p><b>FMCG market research reports</b> provide data on consumer preferences, emerging trends, and gaps in the market. This information helps companies innovate and develop new products that meet current market demands, ensuring successful product launches.</p>
                                                                            </div> -->
                                                                        </div>
                                                                        <div class="faq-item">
                                                                            <div class="faq-label"><p>3.Infertility treatment</p><img src="./assets/images/img/artimeia-removebg-preview (1).png" alt=""></div>
                                                                            <!-- <div class="faq-cont">
                                                                                <p>Novus Insights stands out as a top <b>FMCG market research company</b> because of our customized research solutions, global reach, and deep industry expertise. We deliver insights that are tailored to the specific needs of FMCG businesses, helping them stay ahead of competitors.</p>
                                                                                
                                                                            </div> -->
                                                                        </div>
                                                                        
                                                                        <div class="faq-item">
                                                                            <div class="faq-label"><p>4.Minimally Invasive Surgeries
                                                                            </p><img src="./assets/images/img/heartimg-removebg-preview.png" alt=""></div>
                                                                            <!-- <div class="faq-cont">
                                                                                <p>Through surveys, focus groups, and data analysis, <b>FMCG market research</b> reveals patterns in consumer behavior, such as purchasing habits and brand loyalty. This helps companies refine their marketing strategies and improve customer engagement.</p>
                                                                            </div> -->
                                                                        </div>
                                                                        <div class="faq-item">
                                                                            <div class="faq-label"><p>5. Cancer Screening and Treatment
                                                                            </p><img src="./assets/images/img/agine.png" alt=""></div>
                                                                            <!-- <div class="faq-cont">
                                                                               <p>Yes, <b>market research for FMCG</b> can analyze consumer price sensitivity and competitor pricing models. This enables businesses to set optimal pricing strategies that maximize profit margins while staying competitive in the market.</p>
                                                                            </div> -->
                                                                        </div>
                                                                        <div class="faq-item whatwedo" >
                                                                            <div class="faq-label"><p>6. Adolescent Health</p><img src="./assets/images/img/agine.png" alt=""></div>
                                                                            <!-- <div class="faq-cont">
                                                                               <p>Yes, <b>market research for FMCG</b> can analyze consumer price sensitivity and competitor pricing models. This enables businesses to set optimal pricing strategies that maximize profit margins while staying competitive in the market.</p>
                                                                            </div> -->
                                                                        </div>
                                                                        <div class="faq-item whatwedo">
                                                                            <div class="faq-label"><p>7. Menopausal Care</p><img src="./assets/images/img/agine.png" alt=""></div>
                                                                            <!-- <div class="faq-cont">
                                                                               <p>Yes, <b>market research for FMCG</b> can analyze consumer price sensitivity and competitor pricing models. This enables businesses to set optimal pricing strategies that maximize profit margins while staying competitive in the market.</p>
                                                                            </div> -->
                                                                        </div>
                                                                        <div class="faq-item whatwedo">
                                                                            <div class="faq-label"><p>8. Family Planning and Contraception
                                                                            </p><img src="./assets/images/img/agine.png" alt=""></div>
                                                                            <!-- <div class="faq-cont">
                                                                               <p>Yes, <b>market research for FMCG</b> can analyze consumer price sensitivity and competitor pricing models. This enables businesses to set optimal pricing strategies that maximize profit margins while staying competitive in the market.</p>
                                                                            </div> -->
                                                                        </div>
                                                                       
<!--                                                                      -->
                                                                        <div class="faq-item viewall" id="loadMore">
                                                                            <div class="faq-label"><p>View All<img src="./assets/images/img/Arrow 1.png" alt=""> </p></div>
                                                                        </div> 
                                                                </div>
                                                    </div>
                                                        </div>
                                                    </div>
                                                        <div class="col-sm-12 col-lg-6 faq-rightimg"  data-aos="fade-left" data-aos-duration="800" data-aos-easing="ease-in-sine">
                                                                <img src="./assets/images/img/faqimg.png" alt="">
                                                        </div>
                                                </div>
                                        </div>
                                    
                                 </section>
                                 <!-- doctorpart -->
                                 <section class="doctorpart py-5">
                                            <div class="container2">
                                                    <div class="row">
                                                            <div class="col-sm-12 titlep">
                                                                    <h2 class="heading1 heading2 text-center mb-4">Our Specialists</h2>
                                                                    <p class="text-center">The Obstetrics and Gynaecology department at Graphic Era Hospital is led by a team of highly skilled specialists with years of experience in treating a wide range of women’s health issues. Our team includes experienced obstetricians and gynaecologists, as well as trained nurses, support staff, and counsellors, all working together to ensure the best possible care for our patients.  Our specialists work closely with each patient, ensuring that their health is well looked after with professional care and attention.
                                                                    </p>

                                                            </div>
                                                    </div>
                                                    <div class="row mt-5">
                                                                <!-- <div class="col-sm-12 col-lg-4">
                                                                        <div class="doctor1">
                                                                                        <img src="https://dl.geimshospital.com/uploads/image/fItCdjAY-Dr.-Akhilesh-Pandey--jpg.webp" alt="">
                                                                                        <div class="doctor-content">
                                                                                                <h3>Dr. Akhilesh Pandey</h3>
                                                                                                <span>Director (Cardiac Surgery)</span>
                                                                                        </div>
                                                                        </div>
                                                                </div>
                                                                <div class="col-sm-12 col-lg-4">
                                                                    <div class="doctor1">
                                                                                    <img src="https://dl.geimshospital.com/uploads/image/YSYklyWu-Dr.-Raj-Pratap--jpg.webp" alt="">
                                                                                    <div class="doctor-content">
                                                                                            <h3>Dr. Raj Pratap Singh</h3>
                                                                                            <span>Consultant & Head Cardiology</span>
                                                                                    </div>
                                                                    </div>
                                                            </div>
                                                            <div class="col-sm-12 col-lg-4">
                                                                <div class="doctor1">
                                                                                <img src="https://dl.geimshospital.com/uploads/image/HnbwbSBh-Dr.-Satya-Prakash-Gautam--jpg.webp" alt="">
                                                                                <div class="doctor-content">
                                                                                        <h3>Dr. Himanshu Rana</h3>
                                                                                        <span>Consultant (Anaesthesiology)</span>
                                                                                </div>
                                                                </div>
                                                        </div> -->
                                                        <div class="myslider2">
                                                                    <div class="responsive2">
                                                                        <div class="doctor1">
                                                                            <img src="https://dl.geimshospital.com/uploads/image/tvIB7wU0-Dr-Shweta-Nimonkar-jpg.webp" alt="">
                                                                            <div class="doctor-content">
                                                                                    <h3>Dr. Shweta Nimonkar</h3>
                                                                                    <span>Senior Consultant & Head (Obstetrics & Gynaecology)</span>
                                                                            </div>
                                                            </div>
                                                            <div class="doctor1">
                                                                <img src="https://dl.geimshospital.com/uploads/image/4fkkc8PX-Dr.-Neeta-Bansal--jpg.webp" alt="">
                                                                <div class="doctor-content">
                                                                        <h3>Dr. Neeta Bansal</h3>
                                                                        <span>Senior Consultant (Obstetrics & Gynaecology)</span>
                                                                </div>
                                                </div>
                                                <div class="doctor1">
                                                    <img src="https://dl.geimshospital.com/uploads/image/OmGhDeZe-Dr-Priyanka-Chaudhari-jpg.webp" alt="">
                                                    <div class="doctor-content">
                                                            <h3>Dr. Priyanka Chaudhari</h3>
                                                            <span>Senior Consultant (Obstetrics & Gynaecology)</span>
                                                    </div>
                                    </div>
                                                                    </div>
                                                        </div>
                                                    </div>
                                            </div>
                                 </section>
                                 <!-- patients -->
                                 <section class="patients py-5">
                                        <div class="container2">
                                                <div class="row">
                                                      
                                                                        <div class="col-12">
                                                                            <h2 class="text-center mb-5 heading1 bluecolor">GEIMS: Trusted by Millions of Patients in Over 50 Countries</h2>
                                                                    </div>                                                    
                                                         
                                                </div>
                                                <div class="row mt-5">
                                                        <div class="col-sm-12 col-lg-6">
                                                                    <!-- <h4 class="bluecolor">State-of-the-art Cardiac Care facilities</h4> -->
                                                                    <p class="mt-4">At Graphic Era Hospital, we are committed to providing comprehensive obstetrics and gynaecological care that addresses all aspects of women’s health. Patients trust us for our expertise, state-of-the-art facilities, and patient-centric approach. Here's what sets us apart
                                                                    </p>
                                                        </div>
                                                        <div class="col-sm-6 d-flex justify-content-center">
                                                                <iframe width="70%" height="270px" src="https://www.youtube.com/embed/jC3w1vVJZ_k?si=RQkSwRMULoBHL-0S" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                                                        </div>
                                                        
                                                        <div class="col-sm-12">
                                                                <ul class=" ul">
                                                                    <li><strong>Experienced Specialists:</strong> Our team of experienced obstetricians and gynaecologists provides care across all stages of life, from adolescence to the elderly phase, ensuring that women receive the appropriate treatment.</li>
                                                                    <li><strong>Advanced Diagnostic and Treatment Technologies:</strong> We incorporate the latest technologies in diagnostics and treatment, including 3D/4D ultrasounds, robotic-assisted surgeries, and advanced laparoscopic techniques, all aimed at providing accurate, effective, and minimally invasive treatment.</li>
                                                                    <li><strong>Comprehensive Care for Every Need:</strong> From preventive care to accurate diagnoses, personalized treatments, and post-treatment recovery, we guide our patients through every step, ensuring holistic support at each stage.</li>
                                                                    <li><strong>Patient-Centered Approach:</strong> Our dedicated team prioritises the needs of our patients, collaborating closely to ensure optimal care, comfort, and outcomes.</li>
                                                                    <li><strong>Focus on Womens Health:</strong> Whether you need prenatal care, family planning, or treatment for complex gynaecological conditions, we provide medical care designed specifically for women, with compassion and expertise.</li>
                                                                </ul>
                                                        </div>
                                                </div>
                                        </div>
                                 </section>
                                 <!-- Our Technological Advancements -->
                                 <section class="technological py-5">
                                    <div class="container2">
                                            <div class="row">
                                                  
                                                                    <div class="col-12">
                                                                        <h2 class="text-center mb-5 heading1 bluecolor">Our Technological Advancements</h2>
                                                                        <p class="text-center">Graphic Era Hospital is equipped with modern tools and technology to provide accurate diagnosis and treatment for women’s health conditions. From routine scans to complex surgical procedures, our hospital ensures the best possible outcomes for all our patients.
                                                                        </p>
                                                                </div>                                                    
                                                     
                                            </div>
                                            <div class="row mt-5">
                                                <div class="col-sm-5 d-flex justify-content-center">
                                                   <img src="./assets/images/img/gyne.jpg" alt="" width="100%"> 
                                            </div>
                                                    <div class="col-sm-12 col-lg-7">
                                                            <div class="myslider">
                                                                        <div class="responsive">
                                                                                        <div class="sliders1">
                                                                                            <h4 class="bluecolor">3D/4D Ultrasound Imaging</h4>
                                                                                            <p class="mt-4">These imaging techniques provide clear, dynamic visuals of the baby in the womb, allowing for better monitoring of growth, development, and possible complications. It also helps in detecting conditions like congenital abnormalities early on, ensuring timely intervention and care.
                                                                                             </p>
                                                                                        </div>
                                                                                        <div class="sliders2">
                                                                                            <h4 class="bluecolor">Advanced Laparoscopy
                                                                                            </h4>
                                                                                            <p class="mt-4">This technique uses small incisions and a camera to view the inside of the body. It’s particularly useful for treating conditions like ovarian cysts, endometriosis, and fibroids. The key benefits include faster recovery, minimal scarring, and the ability to perform surgeries with higher precision and less discomfort for patients.
                                                                                            </p>
                                                                                        </div>
                                                                                        <div class="sliders2">
                                                                                            <h4 class="bluecolor">Get Free Assistance
                                                                                            </h4>
                                                                                            <p class="mt-4">Health should never be neglected. If you have concerns or need guidance, don’t wait—reach out to us today. We’re here to offer assistance, whether you need help with a routine appointment, a high-risk pregnancy, or have specific health concerns. Our customer care team is ready to assist with bookings, and emergency care
                                                                                            </p>
                                                                                        </div>
                                                                        </div>
                                                            </div>
                                                                
                                                    </div>
                                                 
                                                    
                                                  
                                            </div>
                                    </div>
                                 </section>
                                 <!--Get Free Assistance-->
                                  <section class="freeassistance">
                                            <div class="container2">
                                                <div class="row justify-content-center">
                                                    <div class=" col-sm-12 col-sm-10 titlep">
                                                            <h2 class="heading1 heading2 text-center mb-4">Get Free Assistance </h2>
                                                            <p class="text-center">Health should never be neglected. If you have concerns or need guidance, don’t wait—reach out to us today. We’re here to offer assistance, whether you need help with a routine appointment, a high-risk pregnancy, or have specific health concerns. Our customer care team is ready to assist with bookings, and emergency care.   </p>
                                                            <a href="#myform" class="banner-btn">
                                                                <!-- <img src="./assets/images/img/b-call.png" alt=""> -->
                                                                <span>Book an Appointment</span></a>

                                                    </div>
                                            </div>
                                            </div>
                                  </section>
                                  <!-- technological -->
                                  <section class="technological py-5">
                                    <div class="container2">
                                            <div class="row">
                                                  
                                                                    <div class="col-12">
                                                                        <h2 class="text-center mb-5 heading1 bluecolor">The GEIMS Advantage</h2>
                                                                        <p class="text-center">At Graphic Era Hospital, we are committed to providing comprehensive obstetrics and gynaecological care that addresses all aspects of women’s health. Patients trust us for our expertise, state-of-the-art facilities, and patient-centric approach. Here's what sets us apart

                                                                        </p>
                                                                </div>                                                    
                                                     
                                            </div>
                                            <div class="row mt-5">
                                              
                                                    <div class="col-sm-12 col-lg-7">
                                                            <div class="myslider">
                                                                        <div class="responsive">
                                                                                        <div class="sliders1">
                                                                                            <!-- <h4 class="bluecolor">1. Multidisciplinary Approach</h4>
                                                                                            <p class="mt-4">A multidisciplinary team including cardiologists, cardiothoracic surgeons, cardiac nurses, rehabilitation specialists, nutritionists, and other allied healthcare professionals is dedicated to ensuring: </p> -->
                                                                                            <ul>
                                                                                                <li>Experienced Specialists: Our team of experienced obstetricians and gynaecologists provides care across all stages of life, from adolescence to the elderly phase, ensuring that women receive the appropriate treatment. </li>
                                                                                                <li>Advanced Diagnostic and Treatment Technologies: We incorporate the latest technologies in diagnostics and treatment, including 3D/4D ultrasounds, robotic-assisted surgeries, and advanced laparoscopic techniques, all aimed at providing accurate, effective, and minimally invasive treatment.
                                                                                                </li>
                                                                                                <li>Comprehensive Care for Every Need: From preventive care to accurate diagnoses, personalized treatments, and post-treatment recovery, we guide our patients through every step, ensuring holistic support at each stage.</li>
                                                                                            </ul>
                                                                                        </div>
                                                                                        <div class="sliders2">
                                                                                            <h4 class="bluecolor">2. Patient-centred care</h4>
                                                                                            <p class="mt-4">At GEIMS, our cardiologists prioritise patient centred care, ensuring that treatment plans are developed in collaboration with the patients, taking into account their unique medical history, circumstances, and overall health. Our cardiac care addresses all critical points in a patient’s treatment journey:</p>
                                                                                            <ul>
                                                                                                <li>Preventative care,</li>
                                                                                                <li>Diagnosis,</li>
                                                                                                <li>Treatment, and</li>
                                                                                              
                                                                                            </ul>
                                                                                        </div>
                                                                        </div>
                                                            </div>
                                                                
                                                    </div>
                                                    <div class="col-sm-5 d-flex justify-content-center">
                                                        <img src="./assets/images/img/TheGEIMSAdvantage.png" alt="" width="100%" height="400px">
                                                </div>
                                                    
                                                  
                                            </div>
                                    </div>
                                 </section>
                                 <section class="faqs-part py-5">
                                            <div class="container2">
                                                <div class="row">
                                                        <div class="col-sm-12">
                                                            <div class="col-12">
                                                                <h2 class=" mb-5 heading1">More Information <br>
                                                                    Questions</h2>
                                                        </div>
                                                        </div>
                                                </div>
                                                    <div class="row ">
                                                                    <div class="col-sm-12 col-lg-9 ">
                                                                        <div class="faq-group">
                     
                                                                            <div class="faq-right">
                                                                                <div class="faq-main">
                                                                                    <div class="faq-item ">
                                                                                        <div class="faq-label activebg1"><p>How is high-risk pregnancy managed at the hospital?
                                                                                        </p><i></i></div>
                                                                                        <div class="faq-cont">
                                                                                            <p>High-risk pregnancies are carefully monitored with frequent check-ups, advanced tests, and personalized care. A team of specialists work together to track the health of both the mother and baby. The hospital provides early intervention, counselling, and lifestyle advice to reduce risks and ensure a safe pregnancy.
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="faq-item">
                                                                                        <div class="faq-label"><p>How do I book an appointment?
                                                                                        </p><i></i></div>
                                                                                        <div class="faq-cont">
                                                                                            <p>Booking an appointment is simple. You can contact our customer care team at 18008897351, or book online through our website.</p>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="faq-item">
                                                                                        <div class="faq-label"><p>What should I expect during and after childbirth at Graphic Era Hospital?</p><i></i></div>
                                                                                        <div class="faq-cont">
                                                                                            <p>You can expect comprehensive care throughout the pregnancy. From routine check-ups to emergency care, our obstetricians and nurses will be with you at every step. Post-delivery, our team will guide you through recovery and provide baby care tips.</p>
                                                                                            
                                                                                        </div>
                                                                                    </div>
                                                                                    
                                                                                    <div class="faq-item">
                                                                                        <div class="faq-label"><p>Is emergency care available for obstetrics and gynaecological concerns?
                                                                                        </p><i></i></div>
                                                                                        <div class="faq-cont">
                                                                                            <p>Yes, we offer 24/7 emergency care for urgent obstetrics and gynaecological medical cases. Whether it’s a sudden complication during pregnancy or an emergency gynaecological issue, our team is ready to provide immediate care.</p>
                                                                                        </div>
                                                                                    </div>
                                                                                    <!-- <div class="faq-item">
                                                                                        <div class="faq-label"><p>Is emergency cardiac care available at Graphic Era Hospital?</p><i></i></div>
                                                                                        <div class="faq-cont">
                                                                                           <p>Yes, Graphic Era Hospital provides 24/7 emergency cardiac care, including immediate evaluation, diagnosis, and treatment for heart attacks and other life-threatening cardiac conditions.</p>
                                                                                        </div>
                                                                                    </div> -->
                                                                            </div>
                                                                </div>
                                                                       </div>
                                                                    </div>
                                                                    <div class="col-sm-12 col-lg-3">
                                                                                    <div class="row">
                                                                                            <div class="col-sm-12">
                                                                                                    <img src="./assets/images/img/faq1 (1).png" alt="" width="100%">
                                                                                            </div>
                                                                                            <div class="col-sm-12 mt-5">
                                                                                                <img src="./assets/images/img/faq1 (2).png" alt="" width="100%" height="300px" class="faqlimg">
                                                                                        </div>
                                                                                    </div>
                                                                    </div>
                                                    </div>
                                            </div>
                                 </section>
                    </main>
                    <footer class="py-4">
                                <div class="footer1">
                                    <div class="container2">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                    <div class="btn1group">
                                                            <a href="#myform" class="btn1"><span>Book an Appointment</span></a>
                                                            <a href="#myform" class="btn2"><img src="./assets/images/img/yellowcall.png" alt="" width=""><span>Emergency Call Number</span></a>
                                                    </div>
                                            </div>
                                    </div>
                                    </div>
                                       
                                </div>
                                <div class="footer2 copy-right">
                                            <div class="container2">
                                                    <div class="row">
                                                        <div class="col-sm-12">
                                                                    <p cla=>Copyright © 2024. <b>Graphic Era Hospital</b></p>
                                                        </div>
                                                    </div>
                                            </div>
                                </div>
                    </footer>

        <div class="stickybtn">
    <a href="#myform">
        <img src="./assets/images/img/bookimg.jpg" alt="">
    </a>
      
  </div>










    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js" integrity="sha512-HGOnQO9+SP1V92SrtZfjqxxtLmVzqZpjFFekvzZVWoiASSQgSr4cw9Kqd2+l8Llp4Gm0G8GIFJ4ddwZilcdb8A==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
            <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<!-- js scrip part start now -->
<!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>-->
<script>       
    $(document).ready(function () {
const utm_source =  new URLSearchParams(window.location.search).get('utm_source');
const utm_medium =  new URLSearchParams(window.location.search).get('utm_medium');
const sourceId =  new URLSearchParams(window.location.search).get('utm_campaign');
console.log(sourceId);
$('#utm_source').val(utm_source);
$('#utm_medium').val(utm_medium);
$('#utm_campaign').val(sourceId);
        })
</script>  
  <script>
document.addEventListener("DOMContentLoaded", () => {
  const items = document.querySelectorAll(".faq-main .faq-item");
  const labels = document.querySelectorAll(".faq-label");

  // Make the first FAQ item active by default
  if (items.length > 0) {
    items[0].classList.add("faq-item-show");
    labels[0].classList.add("activebg");
  }

  labels.forEach((label) => {
    label.addEventListener("click", function () {
      const parentItem = this.closest(".faq-item");

      if (parentItem) {
        const isCurrentlyActive = parentItem.classList.contains("faq-item-show");

        // Toggle the active state of the clicked item
        parentItem.classList.toggle("faq-item-show");
        this.classList.toggle("activebg");

        // Close all other items if you want an exclusive toggle
        items.forEach((item) => {
          if (item !== parentItem) {
            item.classList.remove("faq-item-show");
            item.querySelector(".faq-label").classList.remove("activebg");
          }
        });
      }
    });
  });
});


  </script>
    <script>
        AOS.init({
       duration: 300,
     })
     
           </script>
           <script>
              $('.responsive').slick({
  dots: true,
  infinite: false,
  speed: 300,
  slidesToShow: 1,
  slidesToScroll: 1,
  responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        infinite: true,
        dots: true
      }
    },
    {
      breakpoint: 600,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1
      }
    },
    {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1
      }
    }
    // You can unslick at a given breakpoint now by adding:
    // settings: "unslick"
    // instead of a settings object
  ]
});

// doctorslider
$('.responsive2').slick({
  dots: true,
  infinite: false,
  speed: 300,
  slidesToShow: 3,
  slidesToScroll: 1,
  responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 1,
        infinite: true,
        dots: true
      }
    },
    {
      breakpoint: 800,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 1
      }
    },
    {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1
      }
    }
    // You can unslick at a given breakpoint now by adding:
    // settings: "unslick"
    // instead of a settings object
  ]
});
$(document).ready(function(){
    $("#loadMore").click(function(){
        $(".whatwedo").toggleClass("showallfa")
    })
})

           </script>
                <script>
            // Wait for the DOM to load
            document.addEventListener("DOMContentLoaded", function() {
                const stickyBtn = document.querySelector(".stickybtn");
                
                // Initially hide the sticky button
                stickyBtn.style.display = "none";
        
                window.addEventListener("scroll", function() {
                    if (window.scrollY > 300) {
                        stickyBtn.style.display = "block"; // Show the button
                    } else {
                        stickyBtn.style.display = "none"; // Hide the button
                    }
                });
            });
        </script>
      
</body>
</html>